//*******************************************************************
//
//   File: TaskMan.java
//
//   Author: CS112      Email:  
//
//   Class: NBody 
// 
//   Time spent on this problem: 
//   --------------------
//   
//      This program 
//
//*******************************************************************


public class NBody {

    public static final String PLANETS_FILE = "planets.txt";

    // animation pause (in miliseconds)
    public static final int DELAY = 20;

    // music (2001 theme)
    public static final String MUSIC = "2001theme.wav";

    // background image
    public static final String BACKGROUND = "starfield.jpg";

    // gravitational constant (N m^2 / kg^2)
    public static final double G = 6.67e-11;

                                        // parameters from command line
    public static double T;             // simulate from time 0 to T (s)
    public static double dt;            // time quantum (s)

                                        // parameters from first two lines 
    public static int N;                // number of bodies
    public static double R;             // radius of universe

    public static double[] rx;          // x position (m)
    public static double[] ry;          // y position (m)
    public static double[] vx;          // x velocity (m/s)
    public static double[] vy;          // y velocity (m/s)
    public static double[] mass;        // mass (kg)
    public static String[] image;       // name of gif

    // TODO: read the planet file, new the parallel arrays, and load
    // their values from the file.
    public static void loadPlanets(String planetFileName) {

    }

    public static void runSimulation() {

        // run numerical simulation from 0 to T
        for (double t = 0.0; t < T; t += dt) {

            // the x- and y-components of force
            double[] fx = new double[N];
            double[] fy = new double[N];

            // calculate forces on each object

            // update velocities and positions

            // draw background and then planets

            // pause for a short while, using "animation mode"
            StdDraw.show(DELAY);
        }

    }

    public static void main(String[] args) {

        // TODO: read T and dt from command line.
        T = 0;

        // load planets from file specified in the command line
        String planetFileName = "";
        loadPlanets(planetFileName);

        // rescale coordinates that we can use natural x- and y-coordinates
        StdDraw.setXscale(-R, +R);
        StdDraw.setYscale(-R, +R);

        StdAudio.play( MUSIC );

        // turn on animation mode
        StdDraw.show(0);

        // Run simulation
        runSimulation();

        // print final state of universe to standard output
        System.out.printf("%d\n", N);
        System.out.printf("%.2e\n", R);
        for (int i = 0; i < N; i++) {
            System.out.printf("%11.4e %11.4e %11.4e %11.4e %11.4e %12s\n",
                          rx[i], ry[i], vx[i], vy[i], mass[i], image[i]);
        }

    }
}
